"""
frame_coupling.py

Implementation of the frame coupling operator Φ for the tick‑flip algebra.

The frame coupling operator combines a reflection (distinction) followed
by a symmetric projection (sync).  In operator notation:
    Φ = C ∘ X,
where X reverses the distribution and C averages it with its reverse.
"""

from .tick_state import TickState
from .sync import C
from .distinction import distinction


def Phi(state: TickState) -> TickState:
    """
    Apply the frame coupling operator to a tick state.

    Parameters
    ----------
    state : TickState
        The input tick state.

    Returns
    -------
    TickState
        A new tick state obtained by first applying the distinction (reversal)
        and then the sync (symmetric projection) operators.
    """
    # Apply distinction (reverse) then sync (average with its reverse)
    return C(distinction(state))
